%   function [mic_pos, source_pos] = room_simulator(num_mics, arr_center,mic_dist, source_dist, source_angle, plot)
%   INPUTS:
%       num_mics: number of microphones in the room
%       arr_center: centers of microphone arrays
%       mic_dist: distance between microphones
%       source_dist: distance of source from the array
%       source_angle: angle of source w.r.t mic array
%       plot: flag for whether to plot the room or not
%       arr_type: geometry of array ('circ' = circular array, 'lin' = linear array)
%   OUTPUTS:
%       mic_pos: position of microphones in the room
%       source_pos: position of source in the room

function [mic_pos, source_pos] = room_simulator(room_size, num_mics, arr_center,mic_dist, source_dist, source_angle, arr_type)

disp('Simulating linear array...')
x_limits = (num_mics-1)*mic_dist;
xdim = linspace(-x_limits/2,x_limits/2,num_mics); 
micvec = [xdim ; zeros(1,num_mics); zeros(1,num_mics)];
        
mic_pos_temp = micvec + repmat(arr_center,1,num_mics);
source_pos = zeros(length(source_angle), 3);  
sourceAngle = pi*source_angle/180;
source_pos(:,1) = source_dist.*cos(sourceAngle) + arr_center(1);
source_pos(:,2) = source_dist.*sin(sourceAngle) + arr_center(2);
source_pos(:,3) = arr_center(3);
source_pos = source_pos.';
%% Origin Mapping

room_center_xy = room_size(1:2)/2;
source_pos(1:2,:) = source_pos(1:2,:) + repmat(room_center_xy(1:2).',1,size(source_pos,2));

mic_pos(1,:) = mic_pos_temp(1,:) + room_center_xy(1);
mic_pos(2,:) = mic_pos_temp(2,:) + room_center_xy(2);
mic_pos(3,:) = mic_pos_temp(3,:);

end
