%\| Summer Semester 2014
%\| AudioLabs Lab Course
%===============================
%\| MODULE: Speech enhancement 
%\| Prof. Dr.-Ing Emanuel Habets
%\| Module supervsors: 
%\|     - Soumitro Chakrabarty
%\|     - Maja Taseska
%===============================
%\| Author:
%\|     - Maja Taseska
%===============================
%===============================

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%=============FUNCTION DESCRIPTION====================

% Input parameters
%-----------------
% Input parameters
%-----------------
%\| "Y" ... a matrix of size [numMics x num_frequencies x num_frames]
% containing the input mixture signals
%\| "X" ... a matrix of size [numMics x num_frequencies x num_frames x 2]
% containing the input clean speech signal spectra
%\| "Phi_d" ... a matrix [num_mics x num_mics x num_freq x num_frames]
%contains the PSD matrix of the desired signal. Note that for the MVDR_SV
%the fixed steering vector was required insead of the desired signal PSD
%matrix.
%\| "Phi_u" ... a matrix [num_mics x num_mics x num_freq x num_frames]
%contains the PSD matrix of the interfering signal

%-----------------
% Output parameters
%-----------------
%\| "Ymvdr" ... a matrix of size [ num_frequencies x num_frames]
% containing the filtered mixture signals
%\| "Xmvdr" ... a matrix of size [ num_frequencies x num_frames x 2]
% containing the filtered clean speech signal spectra (required for the
% performance evaluation)


function [Ymvdr, Xmvdr, Vmvdr] = fcn_applyMVDR_RF(Y,X,V,Phi_d,Phi_u)

%=================================
% PLEASE DO NOT MODIFY 
%=================================

min_val = 10^(-40/10);
inv_thr = 10^(-5);

uu = zeros(size(Y,1),1);
uu(1) = 1;

% Memory allocation

Ymvdr = zeros(size(Y,2),size(Y,3));
Xmvdr = zeros(size(X,2),size(X,3),2);
Vmvdr = zeros(size(Y,2),size(Y,3));

h = waitbar(0,'Please wait.');
%______________________________

for idx = 1:size(Y, 3) 
    waitbar(idx/size(Y, 3))
    for fidx = 1:size(Y,2)
        
        %====================================
        % FILL IN THE BLANKS
        %====================================
        
        % Take the current frame of the spectrum
        Y_in = Y(:,fidx,idx);
        X1_in = X(:,fidx,idx,1);
        X2_in = X(:,fidx,idx,2);
        V_in = V(:,fidx,idx);
                
        % the generalized transfer function obtained from Phi_u
        tmp_Phi_d = Phi_d(:,:,fidx,idx);
        
        gg = 
         
        % statistics of the undesired signal
        tmp_Phi_u = Phi_u(:,:,fidx,idx);
        %____________________________________
         
         
        %====================================
        tmp_Phi_u_inv = my_inv(tmp_Phi_u,inv_thr,'p');
        %____________________________________
        
        %====================================
        % FILL IN THE BLANKS
        %====================================
        
        % Compute the filter
       
        % write your code here
        
        H_mvdr = 
        
        % Apply the filter
        Ymvdr(fidx,idx) = 
        Xmvdr(fidx,idx,1) =  
        Xmvdr(fidx,idx,2) =  
        Vmvdr(fidx,idx) = 
        %____________________________________
        
    end
end
close(h)