clear;
close all hidden;

a=-0.5;b=0.5;N=256;t = a:(1/N)*(b-a):b-(1/(N*(b-a))); 
M=4;

%Boxcar-Fenster
figure;
g=boxcar(N)';		
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,-4,4,16);
subplot(1,2,1)
g(1)=0; g(N)=0;
plot(t,g)               
axis([a-0.1,b+0.1,0,1.2])
xlabel('Time t')
%set(gca,'xtick',[])
%title('Box window g')
subplot(1,2,2)
plot(w,abs(ghut(wmin:wmax)))  
axis([-4,4,0,1.2])
xlabel('Frequency \omega')
%set(gca,'xtick',[])
%title('|F(g)|')
printPaperPosition = [1   10   22  10]; %[left, bottom, width, height]
printFile = 'fig_window_box';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));



%Dreieck-Fenster
figure;
g=triang(N)';		
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,-4,4,8);
subplot(1,2,1)
plot(t,g)               
axis([a-0.1,b+0.1,0,1.2])
%set(gca,'xtick',[])
xlabel('Time t')
%title('Triangle window g')
subplot(1,2,2)
plot(w,abs(ghut(wmin:wmax)))  
axis([-4,4,0,0.8])
xlabel('Frequency \omega')
%set(gca,'xtick',[])
%title('|F(g)|')
printPaperPosition = [1   10   22  10]; %[left, bottom, width, height]
printFile = 'fig_window_triangle';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));





%Hanningfenster
figure;
g=hanning(N)';		
[w,ghut,wmin,wmax]=ctft(a,b,N,t,g,-4,4,8);
subplot(1,2,1)
plot(t,g)               
axis([a-0.1,b+0.1,0,1.2])
xlabel('Time t')
%title('Hanning window g')
subplot(1,2,2)
plot(w,abs(ghut(wmin:wmax)))  
axis([-4,4,0,0.8])
xlabel('Frequency \omega')
%title('|F(g)|')
printPaperPosition = [1   10   22  10]; %[left, bottom, width, height]
printFile = 'fig_window_Hann';
set(gcf,'PaperPosition',printPaperPosition); 
print('-dtiff',strcat(printFile));




                        
                        
                        